<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Install function to create the multiple customers table
 */
function multiple_customers_install()
{
    $CI = &get_instance();

    // Get the database table prefix
    $table_prefix = $CI->db->dbprefix;

    // Check if the table already exists to avoid duplicate creation
    if ($CI->db->table_exists($table_prefix . 'project_customers')) {
        return;
    }

    // Create the project_customers table
    $CI->db->query("CREATE TABLE `" . $table_prefix . "project_customers` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `project_id` INT(11) NOT NULL,
        `customer_id` INT(11) NOT NULL,
        PRIMARY KEY (`id`),
        KEY `project_id` (`project_id`),
        KEY `customer_id` (`customer_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ";");
}