<?php
  if (session()->has('lang')) {
      app()->setLocale(session()->get('lang'));
  } else {
      $defaultLang = app\Models\Language::where('is_default', 1)->first();
      if (!empty($defaultLang)) {
          app()->setLocale($defaultLang->code);
      }
  }
?>


<?php $__env->startSection('breadcrumb-title'); ?>
  <?php echo e(__('Page Not Found')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb-link'); ?>
  <?php echo e(__('404')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <!--  Error section start  -->
  <div class="error-section ptb-120 text-center">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-6">
          <div class="not-found">
            <svg data-src="<?php echo e(asset('assets/front/img/404.svg')); ?>" data-unique-ids="disabled" data-cache="disabled"></svg>
          </div>
          <div class="error-txt">
            <h2><?php echo e(__("You're lost")); ?>...</h2>
            <p class="mx-auto">
              <?php echo e(__('The page you are looking for might have been moved, renamed, or might never existed.')); ?>


            </p>
            <a href="<?php echo e(route('front.index')); ?>" class="btn btn-lg btn-primary"><?php echo e(__('Go to Home')); ?></a>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--  Error section end  -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/samiulalimpratik/Sites/businesso/businesso/resources/views/errors/404.blade.php ENDPATH**/ ?>